using System;
using Gtk;
using Gdk;
using AppIndicator;

public partial class MainWindow: Gtk.Window
{	
	private String _ExecutableFolder = "";
	private String ExecutableFolder {
		get {
			if (_ExecutableFolder == "")
				_ExecutableFolder = System.IO.Path.GetDirectoryName(Environment.GetCommandLineArgs()[0]);

			return _ExecutableFolder;
		}
	}

	public MainWindow (): base (Gtk.WindowType.Toplevel)
	{
		Build ();
		
		BuildMenu();
	}
	
	private void BuildMenu()
	{
		ApplicationIndicator indicator = 
			new ApplicationIndicator (
				"sample-application", 		//id of the the indicator icon
				"app-icon",			        //file name of the icon (will look for app-icon.png) 
				Category.ApplicationStatus, 
				ExecutableFolder            //the folder where to look for app-icon.png
				);	
	
		//Build Popup Menu for ApplicationIndicator
		Menu popupMenu = new Menu ();

		//Show menu item
		ImageMenuItem menuItemShow = new ImageMenuItem ("Show");
		menuItemShow.Image = new Gtk.Image(Stock.Info, IconSize.Menu);
		menuItemShow.Activated += (sender, e) => this.Visible = !this.Visible;
		popupMenu.Append(menuItemShow);

		popupMenu.Append(new SeparatorMenuItem());

		//Quit menu item
		ImageMenuItem menuItemQuit = new ImageMenuItem ("Quit");
		menuItemQuit.Image = new Gtk.Image (Stock.Quit, IconSize.Menu);
		menuItemQuit.Activated += (sender, e) => Application.Quit ();
		popupMenu.Append (menuItemQuit);
		
		popupMenu.ShowAll();
		
		//Assign menu and make indicator active
		indicator.Menu = popupMenu;
		indicator.Status = AppIndicator.Status.Active;	
	}
	
	protected void OnDeleteEvent (object sender, DeleteEventArgs a)
	{
		Application.Quit ();
		a.RetVal = true;
	}
}
